// JUnit Assert framework can be used for verification

import net.sf.sahi.client.Browser;

import org.springframework.beans.factory.annotation.Autowired;

import com.thoughtworks.twist.core.execution.TwistScenarioDataStore;

import junit.framework.Assert;

public class Reports {

	private Browser browser;

	//@Autowired
	private TwistScenarioDataStore scenarioStore;

	public Reports(Browser browser) {
		this.browser = browser;
	}

	public void goToAdminister() throws Exception {
		String[] divVal = {"Ranking Mode: Customized Worklist Filter Mode: Needs Protocol Ready for Examination Interpretation QA Suspended Show All Click Mode: Edit The Protocol View The Protocol Checkmark Toggle"};
		String[] linkVal = {"View Reports"};
		browser.div(divVal).click();
		browser.link(linkVal).click();
	
	}

	public void goToViewReports() throws Exception {
		String[] linkVal = {"View Reports"};
		browser.link(linkVal).click();
	
	}

	public void openViewDepartmentActivityReport() throws Exception {
		String[] linkVal  =  {"View Department Ticket Processing Activity Analysis Report"};  //View Department Activity Report
		browser.link(linkVal).click();
	
	}

	public void cancelDepartmentReport() throws Exception {
		String[]  linkVal  = {"Exit"};
		browser.link(linkVal).click();
	
	}

	public void validateDepartmentActivityReportIsOpened() throws Exception {
		String[] headingVal = {"View Department Ticket Processing Activity Analysis Report"};  //View Department Activity Report
 		Assert.assertTrue(browser.heading1(headingVal).exists());
	
	}

	public void openUserActivityAnalysisReport() throws Exception {
		String[] linkVal = {"View User Activity Report"}; //Analysis
		browser.link(linkVal).click();
	
	}

	public void cancelUserActivityAnalysisReport() throws Exception {
		String[]  linkVal  = {"Exit"};
		browser.link(linkVal).click();
	
	}

}